﻿
Partial Class wishlistmanager
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    Protected Sub btnDone_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'redirect back to the swap manager
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'check that the user is logged in
        Call CheckLogin()
        'get the site info
        ThisSite = Session("ThisSite")
        'if this is the first time the page has loaded
        If IsPostBack = False Then
            'display the wish list
            Call DisplayWishList()
        End If
    End Sub

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub

    Sub DisplayWishList()
        'open a connection to the wish list table
        Dim WishList As New DatabaseTable("dvd.mdb", "select * from wishlist order by description", "#PN", "#PW")
        'var to store a single wish list item
        Dim AnItem As String
        'var to store the wish list number
        Dim WishListNo As Integer
        'var to store the number of items in the wish list
        Dim ListCount As Integer
        'counter for the loop
        Dim Counter As Integer
        'clear the list box
        lstWishList.Items.Clear()
        'get the number of items in the wish list table
        ListCount = WishList.Count
        'loop through each item
        For Counter = 0 To ListCount - 1
            'get the description of the item
            AnItem = WishList.RecordNumber(Counter).Item("Description")
            'get the primary key of the item
            WishListNo = WishList.RecordNumber(Counter).Item("WishListNo")
            'add it to the list
            lstWishList.Items.Add(AnItem)
            'set the primary key on the list
            lstWishList.Items.Item(Counter).Value = WishListNo
        Next
    End Sub

    Protected Sub btnAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        'var to store the wish list item to be added
        Dim WishListItem As String
        'get the wish list item
        WishListItem = txtWishListItem.Text
        'clear the error label
        lblError.Text = ""
        'if it isn't blank
        If WishListItem <> "" Then
            'add the wish list item
            Call AddWishListItem(WishListItem)
            'update the wish list
            Call DisplayWishList()
            'clear the wish list text box
            txtWishListItem.Text = ""
        Else
            'dislpay an error
            lblError.Text = "You must type a description of the item."
        End If
    End Sub

    Sub AddWishListItem(ByVal WishListItem As String)
        'this sub adds a wish list item to the database
        '
        'open the wish list table
        Dim WishList As New DatabaseTable("dvd.mdb", "select * from wishlist", "#PN", "#PW")
        'set the description
        WishList.NewRecord.Item("Description") = WishListItem
        'add the record
        WishList.AddNewRecord()
        'save the changes
        WishList.SaveChanges()
    End Sub

    Protected Sub btnRemove_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnRemove.Click
        'var to store the wish list index
        Dim WishListIndex As Integer
        'var to store the wish list id
        Dim WishListID As Integer
        'get the index of the selected entry in the list
        WishListIndex = lstWishList.SelectedIndex
        'clear the error label
        lblError.Text = ""
        'if an item has been selected 
        If WishListIndex <> NO_ITEM Then
            'get the primary key of this item
            WishListID = lstWishList.SelectedValue
            'remove the item
            Call RemoveWishListItem(WishListID)
            'update the wish list
            Call DisplayWishList()
        Else
            'display an error
            lblError.Text = "You must select an item from the list first."
        End If
    End Sub

    Sub RemoveWishListItem(ByVal WishListID As Integer)
        'this sub removes a wish list item identified by wish list id (primary key)
        '
        'open a connection to the wish list table
        Dim WishList As New DatabaseTable("dvd.mdb", "select * from wishlist where wishlistno=" & WishListID, "#PN", "#PW")
        'if the record is found
        If WishList.Count = 1 Then
            'remove the record
            WishList.RemoveRecord(0)
            'save the changes
            WishList.SaveChanges()
        End If
    End Sub
End Class
